	% Spectrum of the interpolated signals
	clear all, close all 
	F = [0,0.2,0.8,1]; 		A = [0,1,0,0];
	x = fir2(128, F, A); 	% Original signal
	wT = linspace(0, pi, 512); 
	for L = 1:4
		yinterp = interp(x, L); % Interpolated signal 
		Y = (1/L)*fft(yinterp, 1024);
		subplot(4,1,L),	PLOT_ABS_Z(wT, abs(Y(1:512)),strcat('Y_',int2str(L)))
		text(0.9,0.5,strcat({'L = '},int2str(L)))
	end
	xlabel('{\it\omegaT} [rad]');
		
